<?php
/**
 * DeliveryReportDeliveredSecondsByResolution
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Models;

use \ArrayAccess;
use \MuxPhp\ObjectSerializer;

/**
 * DeliveryReportDeliveredSecondsByResolution Class Doc Comment
 *
 * @category Class
 * @description Seconds delivered broken into resolution tiers. Each tier will only be displayed if there was content delivered in the tier.
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class DeliveryReportDeliveredSecondsByResolution implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DeliveryReport_delivered_seconds_by_resolution';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tier_2160p' => 'double',
        'tier_1440p' => 'double',
        'tier_1080p' => 'double',
        'tier_720p' => 'double',
        'tier_audio_only' => 'double'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'tier_2160p' => 'double',
        'tier_1440p' => 'double',
        'tier_1080p' => 'double',
        'tier_720p' => 'double',
        'tier_audio_only' => 'double'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'tier_2160p' => false,
        'tier_1440p' => false,
        'tier_1080p' => false,
        'tier_720p' => false,
        'tier_audio_only' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tier_2160p' => 'tier_2160p',
        'tier_1440p' => 'tier_1440p',
        'tier_1080p' => 'tier_1080p',
        'tier_720p' => 'tier_720p',
        'tier_audio_only' => 'tier_audio_only'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tier_2160p' => 'setTier2160p',
        'tier_1440p' => 'setTier1440p',
        'tier_1080p' => 'setTier1080p',
        'tier_720p' => 'setTier720p',
        'tier_audio_only' => 'setTierAudioOnly'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tier_2160p' => 'getTier2160p',
        'tier_1440p' => 'getTier1440p',
        'tier_1080p' => 'getTier1080p',
        'tier_720p' => 'getTier720p',
        'tier_audio_only' => 'getTierAudioOnly'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        // MUX: enum hack (self::) due to OAS emitting problems.
        //      please re-integrate with mainline when possible.
        //      src: https://github.com/OpenAPITools/openapi-generator/issues/9038
        $this->setIfExists('tier_2160p', $data ?? [], null);
        $this->setIfExists('tier_1440p', $data ?? [], null);
        $this->setIfExists('tier_1080p', $data ?? [], null);
        $this->setIfExists('tier_720p', $data ?? [], null);
        $this->setIfExists('tier_audio_only', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tier_2160p
     *
     * @return double|null
     */
    public function getTier2160p()
    {
        return $this->container['tier_2160p'];
    }

    /**
     * Sets tier_2160p
     *
     * @param double|null $tier_2160p Total number of delivered seconds during this time window that had a resolution larger than the 1440p tier (over 4,194,304 pixels total).
     *
     * @return self
     */
    public function setTier2160p($tier_2160p)
    {

        if (is_null($tier_2160p)) {
            throw new \InvalidArgumentException('non-nullable tier_2160p cannot be null');
        }

        $this->container['tier_2160p'] = $tier_2160p;

        return $this;
    }

    /**
     * Gets tier_1440p
     *
     * @return double|null
     */
    public function getTier1440p()
    {
        return $this->container['tier_1440p'];
    }

    /**
     * Sets tier_1440p
     *
     * @param double|null $tier_1440p Total number of delivered seconds during this time window that had a resolution larger than the 1080p tier but less than or equal to the 2160p tier (over 2,073,600 and <= 4,194,304 pixels total).
     *
     * @return self
     */
    public function setTier1440p($tier_1440p)
    {

        if (is_null($tier_1440p)) {
            throw new \InvalidArgumentException('non-nullable tier_1440p cannot be null');
        }

        $this->container['tier_1440p'] = $tier_1440p;

        return $this;
    }

    /**
     * Gets tier_1080p
     *
     * @return double|null
     */
    public function getTier1080p()
    {
        return $this->container['tier_1080p'];
    }

    /**
     * Sets tier_1080p
     *
     * @param double|null $tier_1080p Total number of delivered seconds during this time window that had a resolution larger than the 720p tier but less than or equal to the 1440p tier (over 921,600 and <= 2,073,600 pixels total).
     *
     * @return self
     */
    public function setTier1080p($tier_1080p)
    {

        if (is_null($tier_1080p)) {
            throw new \InvalidArgumentException('non-nullable tier_1080p cannot be null');
        }

        $this->container['tier_1080p'] = $tier_1080p;

        return $this;
    }

    /**
     * Gets tier_720p
     *
     * @return double|null
     */
    public function getTier720p()
    {
        return $this->container['tier_720p'];
    }

    /**
     * Sets tier_720p
     *
     * @param double|null $tier_720p Total number of delivered seconds during this time window that had a resolution within the 720p tier (up to 921,600 pixels total, based on typical 1280x720).
     *
     * @return self
     */
    public function setTier720p($tier_720p)
    {

        if (is_null($tier_720p)) {
            throw new \InvalidArgumentException('non-nullable tier_720p cannot be null');
        }

        $this->container['tier_720p'] = $tier_720p;

        return $this;
    }

    /**
     * Gets tier_audio_only
     *
     * @return double|null
     */
    public function getTierAudioOnly()
    {
        return $this->container['tier_audio_only'];
    }

    /**
     * Sets tier_audio_only
     *
     * @param double|null $tier_audio_only Total number of delivered seconds during this time window that had a resolution of audio only.
     *
     * @return self
     */
    public function setTierAudioOnly($tier_audio_only)
    {

        if (is_null($tier_audio_only)) {
            throw new \InvalidArgumentException('non-nullable tier_audio_only cannot be null');
        }

        $this->container['tier_audio_only'] = $tier_audio_only;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


